//****************************************************************************
// @Module        General Purpose Timer Array 0 (GPTA0)
// @Filename      GPTA0.c
// @Project       ClassicDTC3level5phase.dav
//----------------------------------------------------------------------------
// @Controller    Infineon TC1796
//
// @Compiler      Tasking 2.0
//
// @Codegenerator 2.3
//
// @Description   This file contains functions that use the GPTA0 module.
//
//----------------------------------------------------------------------------
// @Date          1/25/1999 12:07:06 PM
//
//****************************************************************************

// USER CODE BEGIN (GPTA0_General,1)

// USER CODE END



//****************************************************************************
// @Project Includes
//****************************************************************************

#include "MAIN.h"

// USER CODE BEGIN (GPTA0_General,2)
//#include "SpaceVector.h"

#include "stdio.h"
#include "SpaceVector.h"
#include "math.h"

// USER CODE END


//****************************************************************************
// @Macros
//****************************************************************************

// USER CODE BEGIN (GPTA0_General,3)

// USER CODE END


//****************************************************************************
// @Defines
//****************************************************************************

// USER CODE BEGIN (GPTA0_General,4)

   
// USER CODE END


//****************************************************************************
// @Typedefs
//****************************************************************************

// USER CODE BEGIN (GPTA0_General,5)

// USER CODE END


//****************************************************************************
// @Imported Global Variables
//****************************************************************************

// USER CODE BEGIN (GPTA0_General,6)

    
  
  // USER CODE END


//****************************************************************************
// @Global Variables
//****************************************************************************

// USER CODE BEGIN (GPTA0_General,7)

   unsigned int PulseWidth[5];
   unsigned int	PulseWidthA;
   unsigned int	PulseWidthB;
   unsigned int	PulseWidthC;
   unsigned int	PulseWidthD;
   unsigned int	PulseWidthE;
   unsigned int StartFlag=0x0;
   unsigned int IGBTstate[5]={0,0,0,0,0};
   unsigned int SetTimer_0[5];
   unsigned int ResetTimer_0[5];
   unsigned int UpperBand;
   unsigned int LowerBand;
    
   //float sine[200];

   int flag=0;
   int SpeedCalCnt=0;
   int Temp=0;
   float Tem=0;
   int LookupTableFlag;
   int ImbalanceFlag=0;
  // int ImbalFlag;
 //  int tempi1_1;
   int data;
   int AbsoluteEncoder_temp;
   int AbsoluteEncoder_temp1;
   int AbsoluteEncoder_temp2;
   int AbsoluteEncoder_temp3;
   int AbsoluteEncoder_temp4;
   int SpeedCounter;
   int RotorPositionPre;
   int InitialPosition;
   int RotorPosition;
   int DCOffSet[7];
   int RealValue[7];
   int CurrentOffSet_a;
   int CurrentOffSet_b;
   int CurrentOffSet_c;
   int CurrentOffSet_d;
   int CurrentOffSet_e;
   int ReturnVal;
   int DCLinkOffSet;
   int UpperCapVolOffSet;
   int LowerCapVolOffSet;
   int SwitchCnt;
   int SwitchTempVal;
 

   float LowCapVol=0;
   float UppCapVol=0;
   extern float Vdc=0;
   extern float Vdc1=0;

   float RotorSpeed;
   float Temp_Angle;
   float Temp_Angle1;
   float Temp_AngleOld;
   float Initial_Angle;
   float RotorPositionInit;
   float RotorSpeed;
   float MotorSpd;
   float PhaseCurrent_A=0;
   float PhaseCurrent_b;
   float PhaseCurrent_c;
   float PhaseCurrent_d;
   float PhaseCurrent_e;

   float Idss;
   float Iqss;
   float Id3ss;
   float Iq3ss;
   float Idq;

   float Idqse[2];
   float Vdqse[2];
   float Idse;
   float Iqse;
   float Vdse;
   float Vqse;
  // float Vd1ss;
  // float Vq1ss;
   float RotorFluxAngle;
   float RotorFluxSlipAng;
   float SpeedRef=0;

   float RotorFluxAng=0;
   float TempFluxAngle;
   float SlipSpd;
   float RFluxSlipAng=0;
   float RotorFluxMag=0;
   float Wsl;
   float tempf;
   float IdseErrSt=0;
   float IqseErrSt=0;
   float IdseErr;
   float IqseErr;
   float Vqsemax;
   float Vqsemin;
   float SpeedErrSt=0;
   float IqseRef;
   float SpeedErr;
   float StatorFluxDss;
   float StatorFluxQss;
   float StatorFluxMag;
   float StatorFluxAng;
   float Idre;
   float Iqre;
   float Idrs;
   float Iqrs;
   float TorqueVal;
   float TorqueVal_SMO;
   float Upispd;
   float TorRef=0;
   float RotorFluxDss;
   float RotorFluxQss;
   float TorqueErr;
   float FluxErr;
   float TorqueSt=0;
   float FluxSt=0;


   float DCLink;
   float DutyRatio=0.5;
   float VoltageErrStat=0;
   float VoltageErr;
   float VoltageDiff;
   
   
   int TempValue1;
   int TempValue2;
   int TempValue3;
   int TempIdss;
   int TempIqss;
   int TransientIndex;

   unsigned int VectorPlaneFlag=1; 

   float TempVa;
   float TempVa1;
   float TempVa2;

   float I_F[4]={0,0,0,0};
   float I_F_A[4]={0,0,0,0};
   float StatorFlux_d1ss=0;
   float StatorFlux_q1ss=0;
   float StatorFlux_d3ss;
   float StatorFlux_q3ss;

   float StatorFluxMag_F;
   float StatorFluxMag_A;
   float StatorFluxAng_F;
   float StatorFluxAng_A;
   float Vd1q1d3q3[4];
   float Temp_FluxAng;
   float Temp_StatorFluxMag;
   unsigned int NP;



//--------------------------------


// USER CODE END


//****************************************************************************
// @External Prototypes
//****************************************************************************

// USER CODE BEGIN (GPTA0_General,8)

int GetRotorPosition(void)  
  { AbsoluteEncoder_temp=0xffffffff;	  //10bits absolute position sensor
	 					  //P8.0-P8.7, P1.5-P1.6, P8.0---LSB, P1.6---MSB
     do {		
         AbsoluteEncoder_temp1=AbsoluteEncoder_temp;          //Read the position continiuously                                           
         AbsoluteEncoder_temp3=P8_IN&0x000000ff;
        // AbsoluteEncoder_temp2=P9_IN&0x000000C0;
		 AbsoluteEncoder_temp2=P1_IN&0x00000060;
         AbsoluteEncoder_temp4=AbsoluteEncoder_temp2<<3;
         AbsoluteEncoder_temp=AbsoluteEncoder_temp4+AbsoluteEncoder_temp3;
        }	
  while (AbsoluteEncoder_temp!=AbsoluteEncoder_temp1);
  return AbsoluteEncoder_temp;
   
    }  

// USER CODE END


//****************************************************************************
// @Prototypes Of Local Functions
//****************************************************************************

// USER CODE BEGIN (GPTA0_General,9)

// USER CODE END


//****************************************************************************
// @Function      void GPTA0_vInit(void) 
//
//----------------------------------------------------------------------------
// @Description   This is the initialization function of the GPTA0 function 
//                library. It is assumed that the SFRs used by this library 
//                are in their reset state. 
//
//----------------------------------------------------------------------------
// @Returnvalue   None
//
//----------------------------------------------------------------------------
// @Parameters    None
//
//----------------------------------------------------------------------------
// @Date          1/25/1999
//
//****************************************************************************

// USER CODE BEGIN (Init,1)

// USER CODE END

void GPTA0_vInit(void)
{

  uword uwaFIFO[52]; // array for write the multiplexer FIFO
  uword uw;

  // USER CODE BEGIN (Init,2)

  // USER CODE END

  ///  -----------------------------------------------------------------------
  ///  Configuration of the Module Clock:
  ///  -----------------------------------------------------------------------
  #ifndef GPTA_CLOCK_INITIALIZATION
  #define GPTA_CLOCK_INITIALIZATION

  ///  - the GPTA module is stopped during sleep mode
  ///  - normal divider mode is selected
  ///  - required GPTA module clock is 74.927 MHz
  ///  - real GPTA module clock is 75.000 MHz

  MAIN_vResetENDINIT();
  GPTA0_CLC      =  0x00000000;  // load clock control register
  while ((GPTA0_CLC & 0x00000002)==2); // wait until module is enabled
  GPTA0_FDR      =  0x000043FF;  // load fractional divider register
  MAIN_vSetENDINIT();

  #endif // end #ifndef GPTA_CLOCK_INITIALIZATION

  ///  -----------------------------------------------------------------------
  ///  Configuration of Filter and Prescaler Cells 0 - 5:
  ///  -----------------------------------------------------------------------
  ///  FPC0 configuration:
  ///  - FPC0 input selection: 75.0000 MHz
  ///  - FPC0 operation mode: Delayed debounce filter mode on both edges
  ///  - Filter clock selection: Use bus line 0 (=GPTA0 clock / 2^0 (= 75.000 
  ///    MHz; 0.0133 s))
  ///  - FPC0 timer is decremented on glitch
  ///  - FPC0 compare value is 0x0000

  GPTA0_FPCCTR0  =  0x00200000;  // load FPC0 control register
  GPTA0_FPCTIM0  =  0x00000000;  // load FPC0 timer register

  ///  FPC1 configuration:
  ///  - FPC1 input selection: 75.0000 MHz
  ///  - FPC1 operation mode: Delayed debounce filter mode on both edges
  ///  - Filter clock selection: Use bus line 0 (=GPTA0 clock / 2^0 (= 75.000 
  ///    MHz; 0.0133 s))
  ///  - FPC1 timer is decremented on glitch
  ///  - FPC1 compare value is 0x0000

  GPTA0_FPCCTR1  =  0x00200000;  // load FPC1 control register
  GPTA0_FPCTIM1  =  0x00000000;  // load FPC1 timer register

  ///  FPC2 configuration:
  ///  - FPC2 input selection: 75.0000 MHz
  ///  - FPC2 operation mode: Delayed debounce filter mode on both edges
  ///  - Filter clock selection: Use bus line 0 (=GPTA0 clock / 2^0 (= 75.000 
  ///    MHz; 0.0133 s))
  ///  - FPC2 timer is decremented on glitch
  ///  - FPC2 compare value is 0x0000

  GPTA0_FPCCTR2  =  0x00200000;  // load FPC2 control register
  GPTA0_FPCTIM2  =  0x00000000;  // load FPC2 timer register

  ///  FPC3 configuration:
  ///  - FPC3 input selection: 75.0000 MHz
  ///  - FPC3 operation mode: Delayed debounce filter mode on both edges
  ///  - Filter clock selection: Use bus line 0 (=GPTA0 clock / 2^0 (= 75.000 
  ///    MHz; 0.0133 s))
  ///  - FPC3 timer is decremented on glitch
  ///  - FPC3 compare value is 0x0000

  GPTA0_FPCCTR3  =  0x00200000;  // load FPC3 control register
  GPTA0_FPCTIM3  =  0x00000000;  // load FPC3 timer register

  ///  FPC4 configuration:
  ///  - FPC4 input selection: 75.0000 MHz
  ///  - FPC4 operation mode: Delayed debounce filter mode on both edges
  ///  - Filter clock selection: Use bus line 0 (=GPTA0 clock / 2^0 (= 75.000 
  ///    MHz; 0.0133 s))
  ///  - FPC4 timer is decremented on glitch
  ///  - FPC4 compare value is 0x0000

  GPTA0_FPCCTR4  =  0x00200000;  // load FPC4 control register
  GPTA0_FPCTIM4  =  0x00000000;  // load FPC4 timer register

  ///  FPC5 configuration:
  ///  - FPC5 input selection: 75.0000 MHz
  ///  - FPC5 operation mode: Delayed debounce filter mode on both edges
  ///  - Filter clock selection: Use bus line 0 (=GPTA0 clock / 2^0 (= 75.000 
  ///    MHz; 0.0133 s))
  ///  - FPC5 timer is decremented on glitch
  ///  - FPC5 compare value is 0x0000

  GPTA0_FPCCTR5  =  0x00200000;  // load FPC5 control register
  GPTA0_FPCTIM5  =  0x00000000;  // load FPC5 timer register


  GPTA0_FPCSTAT  =  0x00000000;  // load FPC status register


  ///  -----------------------------------------------------------------------
  ///  Configuration of Phase Discrimination Logic Cells 0 - 1:
  ///  -----------------------------------------------------------------------
  ///  PDL0 configuratin:
  ///  - PDL0 provide DCM0 cell input with FPC0 output (= 75.0000 MHz)
  ///  - PDL0 operates in '2 Sensor Mode' and provide DCM1 cell input with 
  ///    FPC2 output (= 75.0000 MHz)

  ///  PDL1 configuratin:
  ///  - PDL1 provide DCM2 cell input with FPC3 output (= 75.0000 MHz)
  ///  - PDL1 operates in '2 Sensor Mode' and provide DCM3 cell input with 
  ///    FPC5 output (= 75.0000 MHz)

  GPTA0_PDLCTR   =  0x00000000;  // load PDL control register

  ///  -----------------------------------------------------------------------
  ///  Configuration of Duty Cycle Measurement and Limit Checking Cells 0 - 3:
  ///  -----------------------------------------------------------------------
  ///  DCM0 configuration:
  ///  - DCM0 input signal is 75.0000 MHz
  ///  - DCM0 capture the timer contents to CAV capture register on a falling 
  ///    input signal edge

  GPTA0_DCMCTR0  =  0x00000000;  // load DCM control register 0
  GPTA0_DCMCOV0  =  0x00000000;  // load DCM capture/compare register 0
  GPTA0_DCMTIM0  =  0x00000000;  // load DCM timer register 0
  GPTA0_DCMCAV0  =  0x00000000;  // load DCM capture register 0

  ///  DCM1 configuration:
  ///  - DCM1 input signal is 75.0000 MHz
  ///  - DCM1 capture the timer contents to CAV capture register on a falling 
  ///    input signal edge

  GPTA0_DCMCTR1  =  0x00000000;  // load DCM control register 1
  GPTA0_DCMCOV1  =  0x00000000;  // load DCM capture/compare register 1
  GPTA0_DCMTIM1  =  0x00000000;  // load DCM timer register 1
  GPTA0_DCMCAV1  =  0x00000000;  // load DCM capture register 1

  ///  DCM2 configuration:
  ///  - DCM2 input signal is 75.0000 MHz
  ///  - DCM2 capture the timer contents to CAV capture register on a falling 
  ///    input signal edge

  GPTA0_DCMCTR2  =  0x00000000;  // load DCM control register 2
  GPTA0_DCMCOV2  =  0x00000000;  // load DCM capture/compare register 2
  GPTA0_DCMTIM2  =  0x00000000;  // load DCM timer register 2
  GPTA0_DCMCAV2  =  0x00000000;  // load DCM capture register 2

  ///  DCM3 configuration:
  ///  - DCM3 input signal is 75.0000 MHz
  ///  - DCM3 capture the timer contents to CAV capture register on a falling 
  ///    input signal edge

  GPTA0_DCMCTR3  =  0x00000000;  // load DCM control register 3
  GPTA0_DCMCOV3  =  0x00000000;  // load DCM capture/compare register 3
  GPTA0_DCMTIM3  =  0x00000000;  // load DCM timer register 3
  GPTA0_DCMCAV3  =  0x00000000;  // load DCM capture register 3

  ///  -----------------------------------------------------------------------
  ///  Configuration of Digital Phase Locked Loop Cell:
  ///  -----------------------------------------------------------------------
  ///  - use DCM0 output signal (= no output signal enabled) as PLL input
  ///  - period of the PLL input signal in GPTA clocks = 0
  ///  - number of output pulses to be generated within one input signal 
  ///    period = 0

  GPTA0_PLLCTR   =  0x00000000;  // load PLL control register
  GPTA0_PLLMTI   =  0x00000000;  // load PLL micro tick register
  GPTA0_PLLSTP   =  0x00000000;  // load PLL step register
  GPTA0_PLLREV   =  0x00000000;  // load PLL reload register
  GPTA0_PLLCNT   =  0x00000000;  // load PLL counter register
  GPTA0_PLLDTR   =  0x00000000;  // load PLL delta register

  ///  -----------------------------------------------------------------------
  ///  Configuration of GPTA Clock Bus 0 - 7:
  ///  -----------------------------------------------------------------------
  ///  - Clock bus signal 0: GPTA0 clock / 2^0 (= 75.000 MHz; 0.0133 s)
  ///  - Clock bus signal 1: PLL output
  ///  - Clock bus signal 2: DCM3 (= no output signal enabled)
  ///  - Clock bus signal 3: DCM2 (= no output signal enabled)
  ///  - Clock bus signal 4: DCM1 (= no output signal enabled)
  ///  - Clock bus signal 5: DCM0 (= no output signal enabled)
  ///  - Clock bus signal 6: FPC1 output (= 75.0000 MHz)
  ///  - Clock bus signal 7: GPTA0 clock / 2^1 (= 37.500 MHz; 0.0267 s)

  GPTA0_CKBCTR   =  0x00001FFF;  // load clock bus control register

  ///  -----------------------------------------------------------------------
  ///  Configuration of Global Timers 0 - 1:
  ///  -----------------------------------------------------------------------
  ///  GT0 configuration:
  ///  - GT0 input is clock bus signal 0 (= GPTA0 clock / 2^0 (= 75.000 MHz; 
  ///    0.0133 s))
  ///  - GT0 compare flag is the 9th bit of the substraction result

  GPTA0_GTCTR0   =  0x00000000;  // load GT control register 0
  GPTA0_GTREV0   =  0x00000000;  // load GT reload value register 0
  GPTA0_GTTIM0   =  0x00000000;  // load GT timer register 0

  ///  GT1 configuration:
  ///  - GT1 input is clock bus signal 0 (= GPTA0 clock / 2^0 (= 75.000 MHz; 
  ///    0.0133 s))
  ///  - GT1 compare flag is the 9th bit of the substraction result

  GPTA0_GTCTR1   =  0x00000000;  // load GT control register 1
  GPTA0_GTREV1   =  0x00000000;  // load GT reload value register 1
  GPTA0_GTTIM1   =  0x00000000;  // load GT timer register 1

  ///  -----------------------------------------------------------------------
  ///  Configuration of Global Timer Cells 0 - 31:
  ///  -----------------------------------------------------------------------
  ///  Global Timer Cell 2 configuration:
  ///  - GTC2 cell is enabled after initialization
  ///  - GTC2 mode: Capture GT0 timer
  ///  - the input line is not connected to the GTC2 cell
  ///  - action transfer: hold the GTC2 output by an local event only

  GPTA0_GTCXR02  =  0x00000000;  // load GTC2 x register
  GPTA0_GTCCTR02  =  0x00000400; // load GTC2 control register


  GPTA0_SRNR     =  0x00000000;  // load service request node redirection 
                                 // register

  ///  -----------------------------------------------------------------------
  ///  Configuration of Local Timer Cells 0 - 63:
  ///  -----------------------------------------------------------------------
  ///  Local Timer Cell 0 configuration:
  ///  - LTC0 cell is enabled after initialization
  ///  - LTC0 mode: timer with reset from adjacent LTC with higher order 
  ///    number
  ///  - input line selection: CLOCK0
  ///  - input line is operating in level sensitive mode
  ///  - action transfer: hold the LTC0 output by an local event only
  ///  - state of select line output SO is 0
  ///  - enable service request on the selected event (= timer with reset)

  GPTA0_LTCXR00  =  0x00000000;  // load LTC0 x register
  GPTA0_LTCCTR00  =  0x0000050B; // load LTC0 control register

  ///  Local Timer Cell 1 configuration:
  ///  - LTC1 cell is enabled after initialization
  ///  - LTC1 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: hold the LTC1 output by an local event only

  GPTA0_LTCXR01  =  0x00001193;  // load LTC1 x register
  GPTA0_LTCCTR01  =  0x00000431; // load LTC1 control register

  ///  Local Timer Cell 2 configuration:
  ///  - LTC2 cell is enabled after initialization
  ///  - LTC2 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC2 output by an local event only

  GPTA0_LTCXR02  =  0x0000F000;  // load LTC2 x register
  GPTA0_LTCCTR02  =  0x00001C31; // load LTC2 control register

  ///  Local Timer Cell 3 configuration:
  ///  - LTC3 cell is enabled after initialization
  ///  - LTC3 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC3 is connected to GPTA0_OUT0 (= P2.8)
  ///  - action transfer: reset the LTC3 output by an local event or copy the 
  ///    previous cell action
  ///  - bypass functionality for LTC3 cell is disabled

  GPTA0_LTCXR03  =  0x0000F000;  // load LTC3 x register
  GPTA0_LTCCTR03  =  0x00003431; // load LTC3 control register

  ///  Local Timer Cell 4 configuration:
  ///  - LTC4 cell is enabled after initialization
  ///  - LTC4 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC4 output by an local event only

  GPTA0_LTCXR04  =  0x0000F000;  // load LTC4 x register
  GPTA0_LTCCTR04  =  0x00001C31; // load LTC4 control register

  ///  Local Timer Cell 5 configuration:
  ///  - LTC5 cell is enabled after initialization
  ///  - LTC5 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC5 is connected to GPTA0_OUT1 (= P2.9)
  ///  - action transfer: reset the LTC5 output by an local event or copy the 
  ///    previous cell action
  ///  - bypass functionality for LTC5 cell is disabled

  GPTA0_LTCXR05  =  0x0000F000;  // load LTC5 x register
  GPTA0_LTCCTR05  =  0x00003431; // load LTC5 control register

  ///  Local Timer Cell 6 configuration:
  ///  - LTC6 cell is enabled after initialization
  ///  - LTC6 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC6 output by an local event only

  GPTA0_LTCXR06  =  0x0000F000;  // load LTC6 x register
  GPTA0_LTCCTR06  =  0x00001C31; // load LTC6 control register

  ///  Local Timer Cell 7 configuration:
  ///  - LTC7 cell is enabled after initialization
  ///  - LTC7 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC7 is connected to GPTA0_OUT2 (= P2.10)
  ///  - action transfer: reset the LTC7 output by an local event or copy the 
  ///    previous cell action
  ///  - bypass functionality for LTC7 cell is disabled

  GPTA0_LTCXR07  =  0x0000F000;  // load LTC7 x register
  GPTA0_LTCCTR07  =  0x00003431; // load LTC7 control register

  ///  Local Timer Cell 8 configuration:
  ///  - LTC8 cell is enabled after initialization
  ///  - LTC8 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC8 output by an local event only

  GPTA0_LTCXR08  =  0x0000F000;  // load LTC8 x register
  GPTA0_LTCCTR08  =  0x00001C31; // load LTC8 control register

  ///  Local Timer Cell 9 configuration:
  ///  - LTC9 cell is enabled after initialization
  ///  - LTC9 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC9 is connected to GPTA0_OUT8 (= P3.0)
  ///  - action transfer: reset the LTC9 output by an local event or copy the 
  ///    previous cell action
  ///  - bypass functionality for LTC9 cell is disabled

  GPTA0_LTCXR09  =  0x0000F000;  // load LTC9 x register
  GPTA0_LTCCTR09  =  0x00003431; // load LTC9 control register

  ///  Local Timer Cell 10 configuration:
  ///  - LTC10 cell is enabled after initialization
  ///  - LTC10 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC10 output by an local event only

  GPTA0_LTCXR10  =  0x0000F000;  // load LTC10 x register
  GPTA0_LTCCTR10  =  0x00001C31; // load LTC10 control register

  ///  Local Timer Cell 11 configuration:
  ///  - LTC11 cell is enabled after initialization
  ///  - LTC11 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC11 is connected to GPTA0_OUT9 (= P3.1)
  ///  - action transfer: reset the LTC11 output by an local event or copy 
  ///    the previous cell action
  ///  - bypass functionality for LTC11 cell is disabled

  GPTA0_LTCXR11  =  0x0000F000;  // load LTC11 x register
  GPTA0_LTCCTR11  =  0x00003431; // load LTC11 control register

  ///  Local Timer Cell 12 configuration:
  ///  - LTC12 cell is enabled after initialization
  ///  - LTC12 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC12 output by an local event only

  GPTA0_LTCXR12  =  0x0000F000;  // load LTC12 x register
  GPTA0_LTCCTR12  =  0x00001C31; // load LTC12 control register

  ///  Local Timer Cell 13 configuration:
  ///  - LTC13 cell is enabled after initialization
  ///  - LTC13 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC13 is connected to GPTA0_OUT10 (= P3.2)
  ///  - action transfer: reset the LTC13 output by an local event or copy 
  ///    the previous cell action
  ///  - bypass functionality for LTC13 cell is disabled

  GPTA0_LTCXR13  =  0x0000F000;  // load LTC13 x register
  GPTA0_LTCCTR13  =  0x00003431; // load LTC13 control register

  ///  Local Timer Cell 14 configuration:
  ///  - LTC14 cell is enabled after initialization
  ///  - LTC14 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC14 output by an local event only

  GPTA0_LTCXR14  =  0x0000F000;  // load LTC14 x register
  GPTA0_LTCCTR14  =  0x00001C31; // load LTC14 control register

  ///  Local Timer Cell 15 configuration:
  ///  - LTC15 cell is enabled after initialization
  ///  - LTC15 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC15 is connected to GPTA0_OUT11 (= P3.3)
  ///  - action transfer: reset the LTC15 output by an local event or copy 
  ///    the previous cell action
  ///  - bypass functionality for LTC15 cell is disabled

  GPTA0_LTCXR15  =  0x0000F000;  // load LTC15 x register
  GPTA0_LTCCTR15  =  0x00003431; // load LTC15 control register

  ///  Local Timer Cell 16 configuration:
  ///  - LTC16 cell is enabled after initialization
  ///  - LTC16 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC16 output by an local event only

  GPTA0_LTCXR16  =  0x0000F000;  // load LTC16 x register
  GPTA0_LTCCTR16  =  0x00001C31; // load LTC16 control register

  ///  Local Timer Cell 17 configuration:
  ///  - LTC17 cell is enabled after initialization
  ///  - LTC17 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC17 is connected to GPTA0_OUT16 (= P3.8)
  ///  - action transfer: reset the LTC17 output by an local event or copy 
  ///    the previous cell action
  ///  - bypass functionality for LTC17 cell is disabled

  GPTA0_LTCXR17  =  0x0000F000;  // load LTC17 x register
  GPTA0_LTCCTR17  =  0x00003431; // load LTC17 control register

  ///  Local Timer Cell 18 configuration:
  ///  - LTC18 cell is enabled after initialization
  ///  - LTC18 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC18 output by an local event only

  GPTA0_LTCXR18  =  0x0000F000;  // load LTC18 x register
  GPTA0_LTCCTR18  =  0x00001C31; // load LTC18 control register

  ///  Local Timer Cell 19 configuration:
  ///  - LTC19 cell is enabled after initialization
  ///  - LTC19 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC19 is connected to GPTA0_OUT17 (= P3.9)
  ///  - action transfer: reset the LTC19 output by an local event or copy 
  ///    the previous cell action
  ///  - bypass functionality for LTC19 cell is disabled

  GPTA0_LTCXR19  =  0x0000F000;  // load LTC19 x register
  GPTA0_LTCCTR19  =  0x00003431; // load LTC19 control register

  ///  Local Timer Cell 20 configuration:
  ///  - LTC20 cell is enabled after initialization
  ///  - LTC20 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC20 output by an local event only

  GPTA0_LTCXR20  =  0x0000F000;  // load LTC20 x register
  GPTA0_LTCCTR20  =  0x00001C31; // load LTC20 control register

  ///  Local Timer Cell 21 configuration:
  ///  - LTC21 cell is enabled after initialization
  ///  - LTC21 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC21 is connected to GPTA0_OUT18 (= P3.10)
  ///  - action transfer: reset the LTC21 output by an local event or copy 
  ///    the previous cell action
  ///  - bypass functionality for LTC21 cell is disabled

  GPTA0_LTCXR21  =  0x0000F000;  // load LTC21 x register
  GPTA0_LTCCTR21  =  0x00003431; // load LTC21 control register

  ///  Local Timer Cell 22 configuration:
  ///  - LTC22 cell is enabled after initialization
  ///  - LTC22 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC22 output by an local event only

  GPTA0_LTCXR22  =  0x0000F000;  // load LTC22 x register
  GPTA0_LTCCTR22  =  0x00001C31; // load LTC22 control register

  ///  Local Timer Cell 23 configuration:
  ///  - LTC23 cell is enabled after initialization
  ///  - LTC23 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC23 is connected to GPTA0_OUT19 (= P3.11)
  ///  - action transfer: reset the LTC23 output by an local event or copy 
  ///    the previous cell action
  ///  - bypass functionality for LTC23 cell is disabled

  GPTA0_LTCXR23  =  0x0000F000;  // load LTC23 x register
  GPTA0_LTCCTR23  =  0x00003431; // load LTC23 control register

  ///  Local Timer Cell 24 configuration:
  ///  - LTC24 cell is enabled after initialization
  ///  - LTC24 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC24 output by an local event only

  GPTA0_LTCXR24  =  0x00000000;  // load LTC24 x register
  GPTA0_LTCCTR24  =  0x00001C31; // load LTC24 control register

  ///  Local Timer Cell 25 configuration:
  ///  - LTC25 cell is enabled after initialization
  ///  - LTC25 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC25 is connected to GPTA0_OUT26 (= P4.2)
  ///  - action transfer: reset the LTC25 output by an local event or copy 
  ///    the previous cell action
  ///  - bypass functionality for LTC25 cell is disabled

  GPTA0_LTCXR25  =  0x0000F000;  // load LTC25 x register
  GPTA0_LTCCTR25  =  0x00003431; // load LTC25 control register

  ///  Local Timer Cell 26 configuration:
  ///  - LTC26 cell is enabled after initialization
  ///  - LTC26 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC26 output by an local event only

  GPTA0_LTCXR26  =  0x0000F000;  // load LTC26 x register
  GPTA0_LTCCTR26  =  0x00001C31; // load LTC26 control register

  ///  Local Timer Cell 27 configuration:
  ///  - LTC27 cell is enabled after initialization
  ///  - LTC27 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC27 is connected to GPTA0_OUT27 (= P4.3)
  ///  - action transfer: reset the LTC27 output by an local event or copy 
  ///    the previous cell action
  ///  - bypass functionality for LTC27 cell is disabled

  GPTA0_LTCXR27  =  0x0000F000;  // load LTC27 x register
  GPTA0_LTCCTR27  =  0x00003431; // load LTC27 control register

  ///  Local Timer Cell 32 configuration:
  ///  - LTC32 cell is enabled after initialization
  ///  - LTC32 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC32 output by an local event only

  GPTA0_LTCXR32  =  0x0000F000;  // load LTC32 x register
  GPTA0_LTCCTR32  =  0x00001C31; // load LTC32 control register

  ///  Local Timer Cell 33 configuration:
  ///  - LTC33 cell is enabled after initialization
  ///  - LTC33 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC33 is connected to GPTA0_OUT6 (= P2.14)
  ///  - action transfer: reset the LTC33 output by an local event or copy 
  ///    the previous cell action
  ///  - bypass functionality for LTC33 cell is disabled

  GPTA0_LTCXR33  =  0x0000F000;  // load LTC33 x register
  GPTA0_LTCCTR33  =  0x00003431; // load LTC33 control register

  ///  Local Timer Cell 34 configuration:
  ///  - LTC34 cell is enabled after initialization
  ///  - LTC34 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC34 output by an local event only

  GPTA0_LTCXR34  =  0x0000F000;  // load LTC34 x register
  GPTA0_LTCCTR34  =  0x00001C31; // load LTC34 control register

  ///  Local Timer Cell 35 configuration:
  ///  - LTC35 cell is enabled after initialization
  ///  - LTC35 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC35 is connected to GPTA0_OUT32 (= P4.8)
  ///  - action transfer: reset the LTC35 output by an local event or copy 
  ///    the previous cell action
  ///  - bypass functionality for LTC35 cell is disabled

  GPTA0_LTCXR35  =  0x0000F000;  // load LTC35 x register
  GPTA0_LTCCTR35  =  0x00003431; // load LTC35 control register

  ///  Local Timer Cell 36 configuration:
  ///  - LTC36 cell is enabled after initialization
  ///  - LTC36 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC36 output by an local event only

  GPTA0_LTCXR36  =  0x0000F000;  // load LTC36 x register
  GPTA0_LTCCTR36  =  0x00001C31; // load LTC36 control register

  ///  Local Timer Cell 37 configuration:
  ///  - LTC37 cell is enabled after initialization
  ///  - LTC37 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC37 is connected to GPTA0_OUT33 (= P4.9)
  ///  - action transfer: reset the LTC37 output by an local event or copy 
  ///    the previous cell action
  ///  - bypass functionality for LTC37 cell is disabled

  GPTA0_LTCXR37  =  0x0000F000;  // load LTC37 x register
  GPTA0_LTCCTR37  =  0x00003431; // load LTC37 control register

  ///  Local Timer Cell 38 configuration:
  ///  - LTC38 cell is enabled after initialization
  ///  - LTC38 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC38 output by an local event only

  GPTA0_LTCXR38  =  0x0000F000;  // load LTC38 x register
  GPTA0_LTCCTR38  =  0x00001C31; // load LTC38 control register

  ///  Local Timer Cell 39 configuration:
  ///  - LTC39 cell is enabled after initialization
  ///  - LTC39 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC39 is connected to GPTA0_OUT34 (= P4.10)
  ///  - action transfer: reset the LTC39 output by an local event or copy 
  ///    the previous cell action
  ///  - bypass functionality for LTC39 cell is disabled

  GPTA0_LTCXR39  =  0x0000F000;  // load LTC39 x register
  GPTA0_LTCCTR39  =  0x00003431; // load LTC39 control register

  ///  Local Timer Cell 40 configuration:
  ///  - LTC40 cell is enabled after initialization
  ///  - LTC40 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC40 output by an local event only

  GPTA0_LTCXR40  =  0x0000F000;  // load LTC40 x register
  GPTA0_LTCCTR40  =  0x00001C31; // load LTC40 control register

  ///  Local Timer Cell 41 configuration:
  ///  - LTC41 cell is enabled after initialization
  ///  - LTC41 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC41 is connected to GPTA0_OUT12 (= P3.4)
  ///  - action transfer: reset the LTC41 output by an local event or copy 
  ///    the previous cell action
  ///  - bypass functionality for LTC41 cell is disabled

  GPTA0_LTCXR41  =  0x0000F000;  // load LTC41 x register
  GPTA0_LTCCTR41  =  0x00003431; // load LTC41 control register

  ///  Local Timer Cell 42 configuration:
  ///  - LTC42 cell is enabled after initialization
  ///  - LTC42 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC42 output by an local event only

  GPTA0_LTCXR42  =  0x0000F000;  // load LTC42 x register
  GPTA0_LTCCTR42  =  0x00001C31; // load LTC42 control register

  ///  Local Timer Cell 43 configuration:
  ///  - LTC43 cell is enabled after initialization
  ///  - LTC43 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC43 is connected to GPTA0_OUT13 (= P3.5)
  ///  - action transfer: reset the LTC43 output by an local event or copy 
  ///    the previous cell action
  ///  - bypass functionality for LTC43 cell is disabled

  GPTA0_LTCXR43  =  0x0000F000;  // load LTC43 x register
  GPTA0_LTCCTR43  =  0x00003431; // load LTC43 control register

  ///  Local Timer Cell 44 configuration:
  ///  - LTC44 cell is enabled after initialization
  ///  - LTC44 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - action transfer: set the LTC44 output by an local event only

  GPTA0_LTCXR44  =  0x0000F000;  // load LTC44 x register
  GPTA0_LTCCTR44  =  0x00001C31; // load LTC44 control register

  ///  Local Timer Cell 45 configuration:
  ///  - LTC45 cell is enabled after initialization
  ///  - LTC45 mode: compare with last timer (= LTC0)
  ///  - enable low level of 'Select Line input' Si
  ///  - enable high level of 'Select Line input' Si
  ///  - output of LTC45 is connected to GPTA0_OUT14 (= P3.6)
  ///  - action transfer: reset the LTC45 output by an local event or copy 
  ///    the previous cell action
  ///  - bypass functionality for LTC45 cell is disabled

  GPTA0_LTCXR45  =  0x0000F000;  // load LTC45 x register
  GPTA0_LTCCTR45  =  0x00003431; // load LTC45 control register

  ///  Local Timer Cell 63 configuration:
  ///  - compare uses normal sequence of timer bits
  ///  - the input line is not connected to the LTC63 cell

  GPTA0_LTCXR63  =  0x00000000;  // load LTC63 x register
  GPTA0_LTCCTR63  =  0x00000000; // load LTC63 control register


  ///  -----------------------------------------------------------------------
  ///  Configuration of the used GPTA0 Port Pins:
  ///  -----------------------------------------------------------------------
  ///  - P2.8 is used as GPTA0 output signal 0 (GPTA0_OUT0)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P2_IOCR8       = (P2_IOCR8 & ~0x000000F0) | 0x00000090; // load control 
                                                          // register

  ///  - P2.9 is used as GPTA0 output signal 1 (GPTA0_OUT1)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P2_IOCR8       = (P2_IOCR8 & ~0x0000F000) | 0x00009000; // load control 
                                                          // register

  ///  - P2.10 is used as GPTA0 output signal 2 (GPTA0_OUT2)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P2_IOCR8       = (P2_IOCR8 & ~0x00F00000) | 0x00900000; // load control 
                                                          // register

  ///  - P2.14 is used as GPTA0 output signal 6 (GPTA0_OUT6)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P2_IOCR12      = (P2_IOCR12 & ~0x00F00000) | 0x00900000; // load control 
                                                           // register

  ///  - P3.0 is used as GPTA0 output signal 8 (GPTA0_OUT8)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P3_IOCR0       = (P3_IOCR0 & ~0x000000F0) | 0x00000090; // load control 
                                                          // register

  ///  - P3.1 is used as GPTA0 output signal 9 (GPTA0_OUT9)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P3_IOCR0       = (P3_IOCR0 & ~0x0000F000) | 0x00009000; // load control 
                                                          // register

  ///  - P3.2 is used as GPTA0 output signal 10 (GPTA0_OUT10)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P3_IOCR0       = (P3_IOCR0 & ~0x00F00000) | 0x00900000; // load control 
                                                          // register

  ///  - P3.3 is used as GPTA0 output signal 11 (GPTA0_OUT11)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P3_IOCR0       = (P3_IOCR0 & ~0xF0000000) | 0x90000000; // load control 
                                                          // register

  ///  - P3.4 is used as GPTA0 output signal 12 (GPTA0_OUT12)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P3_IOCR4       = (P3_IOCR4 & ~0x000000F0) | 0x00000090; // load control 
                                                          // register

  ///  - P3.5 is used as GPTA0 output signal 13 (GPTA0_OUT13)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P3_IOCR4       = (P3_IOCR4 & ~0x0000F000) | 0x00009000; // load control 
                                                          // register

  ///  - P3.6 is used as GPTA0 output signal 14 (GPTA0_OUT14)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P3_IOCR4       = (P3_IOCR4 & ~0x00F00000) | 0x00900000; // load control 
                                                          // register

  ///  - P3.8 is used as GPTA0 output signal 16 (GPTA0_OUT16)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P3_IOCR8       = (P3_IOCR8 & ~0x000000F0) | 0x00000090; // load control 
                                                          // register

  ///  - P3.9 is used as GPTA0 output signal 17 (GPTA0_OUT17)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P3_IOCR8       = (P3_IOCR8 & ~0x0000F000) | 0x00009000; // load control 
                                                          // register

  ///  - P3.10 is used as GPTA0 output signal 18 (GPTA0_OUT18)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P3_IOCR8       = (P3_IOCR8 & ~0x00F00000) | 0x00900000; // load control 
                                                          // register

  ///  - P3.11 is used as GPTA0 output signal 19 (GPTA0_OUT19)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P3_IOCR8       = (P3_IOCR8 & ~0xF0000000) | 0x90000000; // load control 
                                                          // register

  ///  - P4.2 is used as GPTA0 output signal 26 (GPTA0_OUT26)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P4_IOCR0       = (P4_IOCR0 & ~0x00F00000) | 0x00900000; // load control 
                                                          // register

  ///  - P4.3 is used as GPTA0 output signal 27 (GPTA0_OUT27)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P4_IOCR0       = (P4_IOCR0 & ~0xF0000000) | 0x90000000; // load control 
                                                          // register

  ///  - P4.8 is used as GPTA0 output signal 32 (GPTA0_OUT32)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P4_IOCR8       = (P4_IOCR8 & ~0x000000F0) | 0x00000090; // load control 
                                                          // register

  ///  - P4.9 is used as GPTA0 output signal 33 (GPTA0_OUT33)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P4_IOCR8       = (P4_IOCR8 & ~0x0000F000) | 0x00009000; // load control 
                                                          // register

  ///  - P4.10 is used as GPTA0 output signal 34 (GPTA0_OUT34)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P4_IOCR8       = (P4_IOCR8 & ~0x00F00000) | 0x00900000; // load control 
                                                          // register

  ///  - P4.11 is used as GPTA0 output signal 35 (GPTA0_OUT35)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P4_IOCR8       = (P4_IOCR8 & ~0xF0000000) | 0x90000000; // load control 
                                                          // register

  ///  - P4.12 is used as GPTA0 output signal 36 (GPTA0_OUT36)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P4_IOCR12      = (P4_IOCR12 & ~0x000000F0) | 0x00000090; // load control 
                                                           // register

  ///  - P4.13 is used as GPTA0 output signal 37 (GPTA0_OUT37)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P4_IOCR12      = (P4_IOCR12 & ~0x0000F000) | 0x00009000; // load control 
                                                           // register

  ///  - P4.14 is used as GPTA0 output signal 38 (GPTA0_OUT38)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P4_IOCR12      = (P4_IOCR12 & ~0x00F00000) | 0x00900000; // load control 
                                                           // register

  ///  - P4.15 is used as GPTA0 output signal 39 (GPTA0_OUT39)
  ///  - the push/pull function is activated
  ///  - output driver characteristic: medium driver
  ///  - the emergency stop function is disabled

  P4_IOCR12      = (P4_IOCR12 & ~0xF0000000) | 0x90000000; // load control 
                                                           // register


  ///  -----------------------------------------------------------------------
  ///  Configuration of Service Request Nodes 0 - 37:
  ///  -----------------------------------------------------------------------
  ///  - SRN22 service request node configuration:
  ///  - SRN22 interrupt priority level (SRPN) = 1
  ///  - SRN22 CPU interrupt is selected

  GPTA0_SRC22    =  0x00001001;  // set service request control register


  ///  -----------------------------------------------------------------------
  ///  Configuration of the GPTA-to-MSC Multiplexer:
  ///  -----------------------------------------------------------------------
  #ifndef GPTA_TO_MSC_MULTIPLEXER_INITIALIZATION
  #define GPTA_TO_MSC_MULTIPLEXER_INITIALIZATION
  GPTA0_MMXCTR00  =  0x00000000; // load GPTA-to-MSC Multiplex register 00
  GPTA0_MMXCTR01  =  0x00000000; // load GPTA-to-MSC Multiplex register 01
  GPTA0_MMXCTR10  =  0x00000000; // load GPTA-to-MSC Multiplex register 10
  GPTA0_MMXCTR11  =  0x00000000; // load GPTA-to-MSC Multiplex register 11
  #endif // end #ifndef GPTA_TO_MSC_MULTIPLEXER_INITIALIZATION

  ///  -----------------------------------------------------------------------
  ///  Multiplexer Register Array FIFO:
  ///  -----------------------------------------------------------------------
  uwaFIFO[0] = 0x40404040; // save GPTA0_GIMCRL0 register
  uwaFIFO[1] = 0x40404040; // save GPTA0_GIMCRH0 register
  uwaFIFO[2] = 0x40404040; // save GPTA0_GIMCRL1 register
  uwaFIFO[3] = 0x40404040; // save GPTA0_GIMCRH1 register
  uwaFIFO[4] = 0x40404040; // save GPTA0_GIMCRL2 register
  uwaFIFO[5] = 0x40404040; // save GPTA0_GIMCRH2 register
  uwaFIFO[6] = 0x40404040; // save GPTA0_GIMCRL3 register
  uwaFIFO[7] = 0x40404040; // save GPTA0_GIMCRH3 register
  uwaFIFO[8] = 0x303030B0; // save GPTA0_LIMCRL0 register
  uwaFIFO[9] = 0x30303030; // save GPTA0_LIMCRH0 register
  uwaFIFO[10] = 0x30303030; // save GPTA0_LIMCRL1 register
  uwaFIFO[11] = 0x30303030; // save GPTA0_LIMCRH1 register
  uwaFIFO[12] = 0x30303030; // save GPTA0_LIMCRL2 register
  uwaFIFO[13] = 0x30303030; // save GPTA0_LIMCRH2 register
  uwaFIFO[14] = 0x30303030; // save GPTA0_LIMCRL3 register
  uwaFIFO[15] = 0x30303030; // save GPTA0_LIMCRH3 register
  uwaFIFO[16] = 0x30303030; // save GPTA0_LIMCRL4 register
  uwaFIFO[17] = 0x30303030; // save GPTA0_LIMCRH4 register
  uwaFIFO[18] = 0x30303030; // save GPTA0_LIMCRL5 register
  uwaFIFO[19] = 0x30303030; // save GPTA0_LIMCRH5 register
  uwaFIFO[20] = 0x30303030; // save GPTA0_LIMCRL6 register
  uwaFIFO[21] = 0x30303030; // save GPTA0_LIMCRH6 register
  uwaFIFO[22] = 0x30303030; // save GPTA0_LIMCRL7 register
  uwaFIFO[23] = 0x30303030; // save GPTA0_LIMCRH7 register
  uwaFIFO[24] = 0x00171513; // save GPTA0_OMCRL0 register
  uwaFIFO[25] = 0x00210000; // save GPTA0_OMCRH0 register
  uwaFIFO[26] = 0x17151311; // save GPTA0_OMCRL1 register
  uwaFIFO[27] = 0x00252321; // save GPTA0_OMCRH1 register
  uwaFIFO[28] = 0x17151311; // save GPTA0_OMCRL2 register
  uwaFIFO[29] = 0x00000000; // save GPTA0_OMCRH2 register
  uwaFIFO[30] = 0x13110000; // save GPTA0_OMCRL3 register
  uwaFIFO[31] = 0x00000000; // save GPTA0_OMCRH3 register
  uwaFIFO[32] = 0x00272523; // save GPTA0_OMCRL4 register
  uwaFIFO[33] = 0x00000000; // save GPTA0_OMCRH4 register
  uwaFIFO[34] = 0x00000000; // save GPTA0_OMCRL5 register
  uwaFIFO[35] = 0x00000000; // save GPTA0_OMCRH5 register
  uwaFIFO[36] = 0x00000000; // save GPTA0_OMCRL6 register
  uwaFIFO[37] = 0x00000000; // save GPTA0_OMCRH6 register
  uwaFIFO[38] = 0x00000000; // save GPTA0_OMCRL7 register
  uwaFIFO[39] = 0x00000000; // save GPTA0_OMCRH7 register
  uwaFIFO[40] = 0x00000000; // save GPTA0_OMCRL8 register
  uwaFIFO[41] = 0x00000000; // save GPTA0_OMCRH8 register
  uwaFIFO[42] = 0x00000000; // save GPTA0_OMCRL9 register
  uwaFIFO[43] = 0x00000000; // save GPTA0_OMCRH9 register
  uwaFIFO[44] = 0x00000000; // save GPTA0_OMCRL10 register
  uwaFIFO[45] = 0x00000000; // save GPTA0_OMCRH10 register
  uwaFIFO[46] = 0x00000000; // save GPTA0_OMCRL11 register
  uwaFIFO[47] = 0x00000000; // save GPTA0_OMCRH11 register
  uwaFIFO[48] = 0x00000000; // save GPTA0_OMCRL12 register
  uwaFIFO[49] = 0x00000000; // save GPTA0_OMCRH12 register
  uwaFIFO[50] = 0x00000000; // save GPTA0_OMCRL13 register
  uwaFIFO[51] = 0x00000000; // save GPTA0_OMCRH13 register

  GPTA0_MRACTL_MAEN  = 0;            // disable multiplexer array
  while(GPTA0_MRACTL_MAEN != 0);     // wait for bit MAEN
  GPTA0_MRACTL_WCRES = 1;            // reset count

  for(uw = 0; uw < 52; uw++)
  {
    GPTA0_MRADIN = uwaFIFO[51 - uw]; // fill FIFO
  }

  GPTA0_MRACTL_MAEN  = 1;            // enable multiplexer array

  // USER CODE BEGIN (Init,3)

  // USER CODE END

  //// - GPTA0 GT0 timer is not started after initialization; to start the 
  ////   GT0 timer use the macro GPTA0_vStartGTTimer(0)

  //// - GPTA0 GT1 timer is not started after initialization; to start the 
  ////   GT1 timer use the macro GPTA0_vStartGTTimer(1)

  GPTA0_EDCTR_G0EN = 1; // enable GPTA0 timer clock


  // USER CODE BEGIN (Init,4)

  // USER CODE END

} //  End of function GPTA0_vInit


//****************************************************************************
// @Function      void GPTA0_viSRN22(void) 
//
//----------------------------------------------------------------------------
// @Description   This is the interrupt service routine for the Service 
//                Request Node 22 of the GPTA0 module. 
//                Please note that you have to add application specific code 
//                to this function.
//
//----------------------------------------------------------------------------
// @Returnvalue   None
//
//----------------------------------------------------------------------------
// @Parameters    None
//
//----------------------------------------------------------------------------
// @Date          1/25/1999
//
//****************************************************************************

// USER CODE BEGIN (SRN22,1)

// USER CODE END

void INTERRUPT (GPTA0_SRN22INT) GPTA0_viSRN22(void)
{

  // USER CODE BEGIN (SRN22,2)

  // USER CODE END

  if(GPTA0_SRSS2_LTC00)       //  LTC0 event (= timer with reset)
  {
    GPTA0_SRSC2 = 0x00000001; //  reset LTC0 service request bit

    // USER CODE BEGIN (SRN22,3)
      
    //IO_vSetPin(IO_P1_10);
  if (flag==1)
  {
   
   // ---------------3-level SVMPWM with deadband compensation-------------------

//   if(PhaseCurrent_A<0)		     
//   ReturnVal=SetPwmModulation(0, IGBTstate[0], SetTimer_0[0]+DeadBand, ResetTimer_0[0]-DeadBand);
//   else
//   ReturnVal=SetPwmModulation(0, IGBTstate[0], SetTimer_0[0], ResetTimer_0[0]);
//
//
//  if(PhaseCurrent_b<0)		     
//   ReturnVal=SetPwmModulation(1, IGBTstate[1], SetTimer_0[1]+DeadBand, ResetTimer_0[1]-DeadBand);
//   else
//   ReturnVal=SetPwmModulation(1, IGBTstate[1], SetTimer_0[1], ResetTimer_0[1]);
//
//
//   if(PhaseCurrent_c<0)		     
//   ReturnVal=SetPwmModulation(2, IGBTstate[2], SetTimer_0[2]+DeadBand, ResetTimer_0[2]-DeadBand);
//   else
//   ReturnVal=SetPwmModulation(2, IGBTstate[2], SetTimer_0[2], ResetTimer_0[2]);
//
//
//   if(PhaseCurrent_d<0)		     
//   ReturnVal=SetPwmModulation(3, IGBTstate[3], SetTimer_0[3]+DeadBand, ResetTimer_0[3]-DeadBand);
//   else
//   ReturnVal=SetPwmModulation(3, IGBTstate[3], SetTimer_0[3], ResetTimer_0[3]);
//
//
//   if(PhaseCurrent_e<0)		     
//   ReturnVal=SetPwmModulation(4, IGBTstate[4], SetTimer_0[4]+DeadBand, ResetTimer_0[4]-DeadBand);
//   else
//   ReturnVal=SetPwmModulation(4, IGBTstate[4], SetTimer_0[4], ResetTimer_0[4]);

//------------------ 3-level Classic DTC gate signals-----------------------------------------------

//    ClassicDTCPwmModulation(4, IGBTstate[4],PhaseCurrent_e);
//    ClassicDTCPwmModulation(0, IGBTstate[0],PhaseCurrent_A);
//    ClassicDTCPwmModulation(1, IGBTstate[1],PhaseCurrent_b);
//    ClassicDTCPwmModulation(2, IGBTstate[2],PhaseCurrent_c);
//    ClassicDTCPwmModulation(3, IGBTstate[3],PhaseCurrent_d);

//--------------------------2-level inverter state output--------------------------------
      
           
  //**************************** Phase current Analog to Digit Conversion ****** 
   AnalogToDigitConversion(RealValue);

   //********************** Current Measurement*******************************
   PhaseCurrent_c= (RealValue[0]-DCOffSet[0])*0.008959583128;
   PhaseCurrent_d= (RealValue[1]-DCOffSet[1])*0.008659583128;
   //PhaseCurrent_e= (RealValue[2]-DCOffSet[2])*0.008659583128;
   PhaseCurrent_A= (RealValue[3]-DCOffSet[3])*0.008659583128;
   PhaseCurrent_b= (RealValue[4]-DCOffSet[4])*0.008659583128;
   PhaseCurrent_e= -(PhaseCurrent_A+PhaseCurrent_c+PhaseCurrent_d+PhaseCurrent_b);

   //************************Voltage Measurement******************************
   LowCapVol=(RealValue[5])*0.04884;
   UppCapVol=(RealValue[6])*0.04884;
   Vdc=LowCapVol+ UppCapVol;	
      
   // ********************** d1 q1 calculation ****************************
	     
   // cos(a)=0.309016994;  cos(2a)=-0.809016994;   cos(3a)=-0.809016994; cos(4a)=0.309016994;
   Idss=(0.4)*(PhaseCurrent_A+PhaseCurrent_b*0.309016994+PhaseCurrent_c*(-0.809016994)+PhaseCurrent_d*(-0.809016994)+PhaseCurrent_e*0.309016994);

   // sin(a)=0.9510;  sin(2a)=0.587785252;   sin(3a)=-0.587785252;  sin(4a)=-0.9510;
   Iqss=(0.4)*(   PhaseCurrent_b*0.9510+PhaseCurrent_c*0.587785252+PhaseCurrent_d*(-0.587785252)+PhaseCurrent_e*(-0.9510));
   
   // *********************d3 q3 current calculation ***********************

   Id3ss=(0.4)*(PhaseCurrent_A+PhaseCurrent_b*(-0.809016994)+PhaseCurrent_c*0.309016994+PhaseCurrent_d*0.309016994+PhaseCurrent_e*(-0.809016994));
   Iq3ss=(0.4)*(   PhaseCurrent_b*(-0.587785252)+PhaseCurrent_c*0.9510+PhaseCurrent_d*(-0.9510)+PhaseCurrent_e*0.587785252);

   //************************** Rotor Speed Calculation *************************

   RotorPosition= GetRotorPosition();
    if (SpeedCounter==0)
   { 
    RotorSpeed=SpeedCalculation (RotorPosition,RotorPositionPre);
    RotorPositionPre=RotorPosition;

	SpeedErr=SpeedRef-RotorSpeed;
    Upispd=SpeedErrSt+SpeedErr*Kpspd;   
    TorRef=Upispd;         //Integration Correction
    if (Upispd>Torquemax)
      TorRef=Torquemax;
    if (Upispd<Torquemin)
      TorRef=Torquemin; 
    SpeedErrSt=SpeedErrSt+SpeedErr*Kispd+Kcorspd*(TorRef-Upispd);
  
   }
   SpeedCounter=SpeedCounter++;
   if (SpeedCounter>=100)				  //Speed regulation each 6 mS
   SpeedCounter=0;

// *************Rotor Flux Angle Calcaltion****************************

//     TempFluxAngle=RotorPosition-InitialPosition;
//     TempFluxAngle=TempFluxAngle/1024*2*pi;
//     RotorFluxAng=TempFluxAngle+RFluxSlipAng;	//Limit RotorFluxAngle in 0-2*pi
//     RotorFluxAng=fmod(RotorFluxAng, 2*pi);
//
//     if (RotorFluxAng<0)
//     RotorFluxAng=RotorFluxAng+2*pi;

      
//**************Stationary frame to Rotating frame conversion *************** 
 
//      Idse= Idss*cos( RotorFluxAng)+Iqss*sin( RotorFluxAng);
//      Iqse=-Idss*sin( RotorFluxAng)+Iqss*cos( RotorFluxAng);
       
//********************Update rotor flux magnitude and angle*********************
   
  
//   RotorFluxMag=RotorFluxMag+(Lm1*Idse-RotorFluxMag)*Ts/Tr1; 
//				                       //Flux magnitude update
//   if (RotorFluxMag==0)                 //RotorFluxMag can not be zero
//   RotorFluxMag=1e-6;                   //in slip calculation
//
//   SlipSpd=Lm1/RotorFluxMag/Tr1*Iqse;         //Slip speed calculation
//   RFluxSlipAng=RFluxSlipAng+SlipSpd*Ts;    //Flux slip angle update
//                                           //Limit RFluxSlipAng with fmod 0-2*pi
//   RFluxSlipAng=fmod(RFluxSlipAng, 2*pi); 
//   if (RFluxSlipAng<0)                                    
//   RFluxSlipAng=RFluxSlipAng+2*pi;


  // ******* Stator Flux Mag and Angle Calculation *******************

//   RotorFluxDss=RotorFluxMag*cos(RotorFluxAng);
//   RotorFluxQss=RotorFluxMag*sin(RotorFluxAng);
//
//   Idrs= (RotorFluxDss-Lm1*Idss)/Lr1;
//   Iqrs= (RotorFluxQss-Lm1*Iqss)/Lr1;
//
//   StatorFluxDss=Ls1*Idss+Lm1*Idrs;
//   StatorFluxQss=Ls1*Iqss+Lm1*Iqrs;
//
//        
//   StatorFluxMag=sqrt (StatorFluxDss*StatorFluxDss+StatorFluxQss*StatorFluxQss);
//
//	if (StatorFluxMag==0)
//	StatorFluxMag=1e-6;
//	TempVa= StatorFluxDss/StatorFluxMag;
//	if (TempVa>1)
//	TempVa=1;
//	if (TempVa<-1)
//	TempVa=-1;
//
//	StatorFluxAng=acos(TempVa);
//	if (StatorFluxQss<0)
//	StatorFluxAng=2*pi-StatorFluxAng;


 //---------------------------SMO Stator Flux Estimation----------------------

//  	SlidingModeFluxObserver(RotorSpeed, Idss, Iqss,Vd1ss, Vq1ss, I_F);
//
//    StatorFlux_d1ss=Lm1*(I_F[2]-Lm1*I_F[0])/Lr1+Ls1*I_F[0];
//    StatorFlux_q1ss=Lm1*(I_F[3]-Lm1*I_F[1])/Lr1+Ls1*I_F[1];
//    StatorFluxMag_F=sqrt(StatorFlux_d1ss*StatorFlux_d1ss+StatorFlux_q1ss*StatorFlux_q1ss);
//    if (StatorFluxMag_F<=1e-6)
//        StatorFluxMag_F=1e-6;
//    TempVa1=StatorFlux_d1ss/StatorFluxMag_F;
//     if (TempVa1>=1)  TempVa1=1; 
//     if (TempVa1<=-1) TempVa1=-1;
//     StatorFluxAng_F=acos(TempVa1);
//     if (StatorFlux_q1ss<0)
//     StatorFluxAng_F=2*pi-StatorFluxAng_F;
//
//     StatorFluxMag=StatorFluxMag_F;
//     StatorFluxAng=StatorFluxAng_F;
//     StatorFluxDss=StatorFlux_d1ss;
//     StatorFluxQss=StatorFlux_q1ss;

 //-------------------------------------------------------------------------

     // TorqueVal=2.5*Lm1*RotorFluxMag*Iqse/Lr1;

    //TorqueVal=2.5*(StatorFluxDss*Iqss-StatorFluxQss*Idss);

 //-------------------------------------------------------------------------
  
//    TorqueErr=TorqueRef-TorqueVal;           //  Torque and flux regulation
 //   FluxErr=FluxRef-StatorFluxMag_F;
 //-------------------------------------------------------------------------    
//    FluxSt=FluxSt+Kif*FluxErr;   
//    if (FluxSt>FluxErrStmax)	       
//    FluxSt=FluxErrStmax;
//    
//    if (FluxSt<FluxErrStmin)
//    FluxSt=FluxErrStmin;
//   
//    
//    TorqueSt=TorqueSt+Kit*TorqueErr;
//    if (TorqueSt>TorqueErrStmax)
//    TorqueSt=TorqueErrStmax;
//    
//    if (TorqueSt<TorqueErrStmin)
//    TorqueSt=TorqueErrStmin;
//    
//    Vdse=FluxSt+FluxErr*Kpf;
//    Vqse=TorqueSt+TorqueErr*Kpt;
//   
//    if (Vdse>Vdsemax)
//      
//    Vdse=Vdsemax;   
//
//    if (Vdse<Vdsemin)   
//     Vdse=Vdsemin; 
//    
//    Vqsemax=sqrt(Vdsemax*Vdsemax-Vdse*Vdse);      
//    Vqsemin=-Vqsemax;
//    
//    if (Vqse>Vqsemax)  
//    Vqse=Vqsemax; 
//      
//    if (Vqse<Vqsemin)   
//    Vqse=Vqsemin;   
//
//   Vd1ss=Vdse*cos(StatorFluxAng)-Vqse*sin(StatorFluxAng);	 // voltage model using this transformation
//   Vq1ss=Vdse*sin(StatorFluxAng)+Vqse*cos(StatorFluxAng);
////
 // *********************PI controller ******************

  ///PI_Controller(SpeedCounter, SpeedRef, Vdc,RotorSpeed, Idse,Iqse, Vdqse);
  //Vdse=Vdqse[0];
  //Vqse=Vdqse[1];

 //-------------------------PI  Voltage Balance Algorithm--------------------

// -----------------the following code can be used only by SVM------------------

//     VoltageDiff= UppCapVol-LowCapVol;
//     VoltageErr=VoltageRef-VoltageDiff;
//     VoltageErrStat=VoltageErrStat+VoltageErr*KiCapVol;
//	 if (VoltageErrStat>=0.5)
//	 VoltageErrStat=0.5;
//	 if (VoltageErrStat<=0)
//	 VoltageErrStat=0;
// 
//
//	 DutyRatio=VoltageErrStat+KpCapVol*VoltageErr;
//     if (DutyRatio>=0.5)
//        DutyRatio=0.5; 
//     if (DutyRatio<0)
//        DutyRatio=0;

   //  DutyRatio=0.5;
     
//----------------------- Hysteresis control to balance NP voltage---------
	 

//	  if (VoltageDiff>20||VoltageDiff<-20)
//	  	  ImbalanceFlag++;
//	  if(ImbalanceFlag==20)
//		 ImbalanceFlag=1;
//	  else
//	     ImbalanceFlag=0;
//	  	 
  	  	  	   	
//	   	NP=1;
//	  if (VoltageDiff>=0)   //1.5
//       	NP=2;
//      if (VoltageDiff<0)
//		NP=1;


//      if(0>VoltageDiff>-1.5)
//          LowerBand=0;
//
//      if(VoltageDiff<0)
//          LowerBand=1;
//	   //	 NP=1;
// 
//
//    if (UpperBand==1&&LowerBand==0)
//        NP=2;     
//    if (UpperBand==0&&LowerBand==1)
//        NP=1;     
//    if (UpperBand==0&&LowerBand==0)
//	    NP=0;         
   //	 NP=0; 
  

 // ********************** SVPWM Calculation **********************************
  	
  //  Temp++;
 //   Temp=Temp%100;
	
  //	ReturnVal=PWMWidth_Cal(Temp, DutyRatio,Vdc,-Vd1ss,-Vq1ss,RotorFluxAngle,PhaseCurrent_A,PhaseCurrent_b,PhaseCurrent_c,PhaseCurrent_d,PhaseCurrent_e,IGBTstate, PulseWidth); 		       
  //  PWMWidthLimitation(PhaseCurrent_A,PhaseCurrent_b,PhaseCurrent_c,PhaseCurrent_d,PhaseCurrent_e,PulseWidth,SetTimer_0,ResetTimer_0);



//--------------------------slidng mode observer for d1-q1----------------------------------------

    SlidingModeFluxObserver(RotorSpeed, Idss, Iqss, Vd1q1d3q3[0], Vd1q1d3q3[1], I_F);
	StatorFlux_d1ss=(I_F[2]-Lm1*I_F[0])/Lr1*Lm1+Ls1*I_F[0];
    StatorFlux_q1ss=(I_F[3]-Lm1*I_F[1])/Lr1*Lm1+Ls1*I_F[1];
    StatorFluxMag_F=sqrt(StatorFlux_d1ss*StatorFlux_d1ss+StatorFlux_q1ss*StatorFlux_q1ss);
    if (StatorFluxMag_F<=1e-6)
        StatorFluxMag_F=1e-6;
    TempVa1=StatorFlux_d1ss/StatorFluxMag_F;
     if (TempVa1>=1)  TempVa1=1; 
     if (TempVa1<=-1) TempVa1=-1;
     StatorFluxAng_F=acos(TempVa1);
     if (StatorFlux_q1ss<0)
     StatorFluxAng_F=2*pi-StatorFluxAng_F;

     
	 
//-------------------- sliding mode flux observer for d3-q3---------------

    SlidingModeFluxObserver_A(RotorSpeed, Id3ss, Iq3ss, Vd1q1d3q3[2], Vd1q1d3q3[3], I_F_A);
    StatorFlux_d3ss=Lm3*(I_F_A[2]-Lm3*I_F_A[0])/Lr3+Ls3*I_F_A[0];
    StatorFlux_q3ss=Lm3*(I_F_A[3]-Lm3*I_F_A[1])/Lr3+Ls3*I_F_A[1];
    StatorFluxMag_A=sqrt(StatorFlux_d3ss*StatorFlux_d3ss+StatorFlux_q3ss*StatorFlux_q3ss);
    if (StatorFluxMag_A<=1e-6)
        StatorFluxMag_A=1e-6;
    TempVa1=StatorFlux_d3ss/StatorFluxMag_A;
     if (TempVa1>=1)  TempVa1=1; 
     if (TempVa1<=-1) TempVa1=-1;
     StatorFluxAng_A=acos(TempVa1);
     if (StatorFlux_q3ss<0)
     StatorFluxAng_A=2*pi-StatorFluxAng_A;
 //
 // ------------------------Torque Estimation-----------------------------
     TorqueVal=5.0/2*Lm1/Lr1*(I_F[2]*I_F[1]-I_F[3]*I_F[0]);

     //TorqueVal=2.5*( StatorFlux_d1ss*I_F[1]-StatorFlux_q1ss*I_F[0]);
     //TorqueVal=2.5*(StatorFluxDss*Iqss-StatorFluxQss*Idss);

 //-------------------------------------------------------------------------
  
      TorqueErr=TorRef-TorqueVal;           //  Torque and flux regulation
      FluxErr=FluxRef-StatorFluxMag_F;

//      if(0<=RotorSpeed<314/30||0>RotorSpeed>-314/30)
//	  {
//	  TorqueErr=TorRef-TorqueVal;           //  Torque and flux regulation
//      FluxErr=FluxRef-StatorFluxMag;
//
//	  Temp_FluxAng=StatorFluxAng;
//      Temp_StatorFluxMag=StatorFluxMag;
//	  }
//	  else
//	  {
//	     TorqueErr=TorRef-TorqueVal_SMO;           //  Torque and flux regulation
//         FluxErr=FluxRef-StatorFluxMag_F;
//
//	     Temp_FluxAng=StatorFluxAng_F;
//         Temp_StatorFluxMag=StatorFluxMag_F; 
 //	  }


 //-------------------------3-level inverter state selection-----------------------

   // DTCLookUpTable (TorqueErr, FluxErr,RotorSpeed, StatorFluxAng_F, StatorFluxAng_A, StatorFluxMag_F,  Vdc, Vd1q1d3q3, IGBTstate);
    
   // DTCLookUpTableWithNPCompensation (PhaseCurrent_A,PhaseCurrent_b,PhaseCurrent_c,PhaseCurrent_d,PhaseCurrent_e, NP, TorqueErr, FluxErr,RotorSpeed,  StatorFluxAng_F, StatorFluxAng_A,  StatorFluxMag_F,  Vdc, Vd1q1d3q3, IGBTstate);
   // LookupTableFlag=DTCLookUpTable3WithNPBalance(PhaseCurrent_A,PhaseCurrent_b,PhaseCurrent_c,PhaseCurrent_d,PhaseCurrent_e, NP, TorqueErr, FluxErr,RotorSpeed,  StatorFluxAng_F, StatorFluxAng_A,  StatorFluxMag_F,  Vdc, Vd1q1d3q3, IGBTstate,0);
  //-------------------------- 2-level inverter state selection --------------------------
    
    //------------------------ 5-level hysteresis torque band---------------------

    DTCLookupTable_2level(PhaseCurrent_A,PhaseCurrent_b,PhaseCurrent_c,PhaseCurrent_d,PhaseCurrent_e, TorqueErr, FluxErr,RotorSpeed, StatorFluxAng_F, StatorFluxAng_A, StatorFluxMag_F, Vdc, Vd1q1d3q3, IGBTstate);

  //--------------------- 3-level hysteresis Torque Band--------------------------

      // DTCLookupTableWith3HysteresisBand_2level(PhaseCurrent_A,PhaseCurrent_b,PhaseCurrent_c,PhaseCurrent_d,PhaseCurrent_e, TorqueErr, FluxErr,RotorSpeed, StatorFluxAng_F, StatorFluxAng_A, StatorFluxMag_F, Vdc, Vd1q1d3q3, IGBTstate);

       ClassicDTCPwmModulation_2level(4, IGBTstate[4],PhaseCurrent_e);
       ClassicDTCPwmModulation_2level(0, IGBTstate[0],PhaseCurrent_A);
       ClassicDTCPwmModulation_2level(1, IGBTstate[1],PhaseCurrent_b);
       ClassicDTCPwmModulation_2level(2, IGBTstate[2],PhaseCurrent_c);
       ClassicDTCPwmModulation_2level(3, IGBTstate[3],PhaseCurrent_d);


//*************************** Digit To Analog Conversion  ***********************
      
// ******************************AD Chip One************************************
//   
//	   IO_vResetPin(IO_P1_10); //  To enable the Selection of Decoder
//	   IO_vResetPin(IO_P1_11);	// B pin of the Decoder
//	   IO_vResetPin(IO_P1_7);    // A pin of the Decoder
//	   // P9_OUT=(RotorSpeed)*225/350+30;                        // 00, Chip 1, DA output, 01 chip 2, 10, chip3,;     
//	   P9_OUT=StatorFlux_d1ss*100+128; 
//        //DAC, P9.7-P9.0, 8bits data bus 
//	   IO_vResetPin(IO_P9_8);  // P9.8 to write data
//	   IO_vSetPin(IO_P9_8) ;
//	   IO_vSetPin(IO_P1_10); 
//
 //****************************AD chip Two***************************************

	   IO_vResetPin(IO_P1_10);
	   IO_vResetPin(IO_P1_11);	// B pin of the Decoder
	   IO_vSetPin(IO_P1_7);    // A pin of the Decoder

      // P9_OUT=TorRef*10+128;
	  //   P9_OUT=StatorFluxMag_F*100+128;         
	  P9_OUT=StatorFlux_d3ss*10000+128; 
	  // P9_OUT=(RotorSpeed)*225/350+30;  
	 //  P9_OUT=TorqueVal*10+32;                        // 00, Chip 1, DA output, 01 chip 2, 10, chip3,;     
	  // P9_OUT=StatorFluxDss*100+128;             //DAC, P9.7-P9.0, 8bits data bus 
	   IO_vResetPin(IO_P9_8);  // P9.8 to write data
	   IO_vSetPin(IO_P9_8) ;
	   IO_vSetPin(IO_P1_10); 
//
 //*************************AD chip Three**************************************
//
      IO_vResetPin(IO_P1_10);
      IO_vSetPin(IO_P1_11);	// B pin of the Decoder
      IO_vResetPin(IO_P1_7);    // A pin of the Decoder
       //  P9_OUT=128;
      // P9_OUT=StatorFluxMag_F*100+128;
	  //P9_OUT=(StatorFluxDss)*200+128;
	   P9_OUT=StatorFlux_q3ss*10000+128; 
      //	P9_OUT=(RotorSpeed)*10+50;
     // P9_OUT=(RotorSpeed)*225/350+30;
    // P9_OUT=(TorqueVal)*10+32;       // 00, Chip 1, DA output, 01 chip 2, 10, chip3,;  
    //  P9_OUT=StatorFluxQss*100+128;   //DAC, P9.7-P9.0, 8bits data bus 
      IO_vResetPin(IO_P9_8);          // P9.8 to write data
      IO_vSetPin(IO_P9_8) ;
      IO_vSetPin(IO_P1_10); 
//
 //****************************Motor Reference Speed Change***********************

       SwitchTempVal=P1_IN&0x0000200;	  // Starting up button P1.4;
       if (SwitchTempVal==0x0000200)
       SwitchCnt++;
       if (SwitchCnt>=500)
       {SwitchCnt=500;
        SpeedRef=314/5; }

 
 
 // ******************************************************************************

 }   
     if (flag==0)
  {	

   AnalogToDigitConversion(DCOffSet);
   InitialPosition= GetRotorPosition();
   RotorPositionPre=InitialPosition;
   SMOParameterIni_F();
   SMOParameterIni_A();	 	         
   flag=1;
  }    // USER CODE END

  }
  // USER CODE BEGIN (SRN22,8)

  // USER CODE END


} //  End of function GPTA0_viSRN22



// USER CODE BEGIN (GPTA0_General,10)

// USER CODE END

